Jnos 1.10h and prior have a few bugs in the mailbox.c module.  What follows
is a description and a context diff of the changes I made:

I fixed domboxbye() in mailbox.c to use the correct bitmask to test for
expert mode, thus restoring the farewell msg display.  Also, the correct
mask is now used to limit the Jheard list display for hidden ports, to
those permitted to become sysop.  I also found that mbxrecvline() was not
handling telnet options for the sysop "rlogin" via port 513, and so changed
it to test to support telnet options only for TCP protocol links.
73, de James N5KNX
jpd@usl.edu
=====================================================
*** mailbox.oc	Thu Dec 01 01:51:00 1994
--- mailbox.c	Sun Dec 18 17:44:26 1994
***************
*** 937,942 ****
--- 937,943 ----
   * flushed and -2 returned.
   *
   * mbxrecvline() now can gobble up suboptions - 94/02/14 VE4WTS
+  * OH2BNS/N5KNX: don't test for telnet options unless TCP link type
   */
  int
  mbxrecvline(m)
***************
*** 945,960 ****
      int s = m->user;
      int escape = m->escape;
      char *buf = m->line;
!     int c, cnt = 0, opt,cl;
    
      if(buf == NULLCHAR)
          return 0;
      usflush(Curproc->output);
      alarm(Mbtdiscinit*1000L);   /* Start inactivity timeout - WG7J */
      while((c = recvchar(s)) != EOF){
          alarm(0L);
          if(c == IAC &&          /* Telnet command escape */
!            (m->type == TELNET_LINK || m->type == TIP_LINK)) {  /* OH2BNS: makes sense? */
              if((c = recvchar(s)) == EOF)
                  break;
              if(c >= 250 && c < 255 && (opt = recvchar(s)) != EOF){
--- 946,968 ----
      int s = m->user;
      int escape = m->escape;
      char *buf = m->line;
!     int c, cnt = 0, opt,cl, opt_ok=0;
!     struct usock *up;
    
      if(buf == NULLCHAR)
          return 0;
+     if ((up=itop(s)) != NULLUSOCK && up->type == TYPE_TCP)
+         opt_ok++;
      usflush(Curproc->output);
      alarm(Mbtdiscinit*1000L);   /* Start inactivity timeout - WG7J */
      while((c = recvchar(s)) != EOF){
          alarm(0L);
          if(c == IAC &&          /* Telnet command escape */
! #ifdef notdef
!            (m->type == TELNET_LINK || m->type == TIP_LINK || m->type == RLOGIN_LINK)) {  /* OH2BNS: makes sense? */
! #else
!            opt_ok) {
! #endif
              if((c = recvchar(s)) == EOF)
                  break;
              if(c >= 250 && c < 255 && (opt = recvchar(s)) != EOF){
***************
*** 1041,1047 ****
  {
      if (m->type == TELNET_LINK || m->type == TIP_LINK) {
  #ifdef notdef
!         if ((up=itop(m->proc->output)) != NULLSOCK && up->type == TYPE_TCP) {
              up->cb.tcb->??? can't get to telnet->session->ttystate.echo
          }
  #endif
--- 1049,1055 ----
  {
      if (m->type == TELNET_LINK || m->type == TIP_LINK) {
  #ifdef notdef
!         if ((up=itop(m->proc->output)) != NULLUSOCK && up->type == TYPE_TCP) {
              up->cb.tcb->??? can't get to telnet->session->ttystate.echo
          }
  #endif
***************
*** 1072,1078 ****
      updatedefaults(m);
  #endif
      /* Now say goodbye */
!     if(!(m->privs & MBX_EXPERT))
          tprintf("\nThank you %s,\nfor calling %s JNOS.\n\n",
  #ifdef USERLOG
          m->username ? m->username : m->name,
--- 1080,1086 ----
      updatedefaults(m);
  #endif
      /* Now say goodbye */
!     if(!(m->privs & IS_EXPERT))
          tprintf("\nThank you %s,\nfor calling %s JNOS.\n\n",
  #ifdef USERLOG
          m->username ? m->username : m->name,
***************
*** 1296,1302 ****
    
      if(argc > 1){
          if( ((ifp = if_lookup(argv[1])) == NULLIF) || (ifp->type != CL_AX25) ||
!         ((ifp->flags & HIDE_PORT) && !(m->privs & MBX_SYSOP)) ) {
              tprintf(Badinterface,argv[1]);
              return 0;
          }
--- 1304,1310 ----
    
      if(argc > 1){
          if( ((ifp = if_lookup(argv[1])) == NULLIF) || (ifp->type != CL_AX25) ||
!         ((ifp->flags & HIDE_PORT) && !(m->privs & SYSOP_CMD)) ) {
              tprintf(Badinterface,argv[1]);
              return 0;
          }
***************
*** 1304,1310 ****
          return 0;
      }
      for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next){
!         if((ifp->flags & LOG_AXHEARD)  && ( !(ifp->flags & HIDE_PORT) || m->privs&MBX_SYSOP) )
              if(axheard(ifp) == EOF)
                  break;
      }
--- 1312,1318 ----
          return 0;
      }
      for(ifp = Ifaces;ifp != NULLIF;ifp = ifp->next){
!         if((ifp->flags & LOG_AXHEARD)  && ( !(ifp->flags & HIDE_PORT) || m->privs&SYSOP_CMD) )
              if(axheard(ifp) == EOF)
                  break;
      }
===============================
