#include <stdio.h>
#include <conio.h>
#include "global.h"
#include "mbuf.h"
#include "internet.h"
#include "ip.h"
#include "trace.h"
#include "netuser.h"

void
ip_dump(fp,bpp,check)
FILE *fp;
struct mbuf **bpp;
int check;
{
	struct ip ip;
	int16 ip_len, length, csum;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	/* Sneak peek at IP header and find length */
	if(((ip_len = ((*bpp)->data[0] & 0xf) << 2)) < IPLEN) {
		trprintf(fp,"IP: bad header\n");
		return;
	}
	csum = (check == 1) ? cksum(NULLHEADER,*bpp,ip_len) : 0;

	ntohip(&ip,bpp);	/* Can't fail, we've already checked ihl */

	/* Trim data segment if necessary. */
	length = ip.length - ip_len;	/* Length of data portion */
	trim_mbuf(bpp,length);
	textattr(LIGHTGREEN);
	trprintf(fp,"IP: len %u %s",ip.length,inet_ntoa(ip.source));
	trprintf(fp,"->%s ihl %u ttl %u",
		inet_ntoa(ip.dest),ip_len,uchar(ip.ttl));
	if(ip.tos != 0)
		trprintf(fp," tos %u",uchar(ip.tos));
	if(ip.offset != 0 || ip.flags.mf)
		trprintf(fp," id %u offs %u",ip.id,ip.offset);
	if(ip.flags.df)
		trprintf(fp," DF");
	if(ip.flags.mf){
		trprintf(fp," MF");
		check = 0;	/* Bypass host-level checksum verify */
	}
	if(ip.flags.congest)
		trprintf(fp," CE");
	if(csum)
		trprintf(fp," CHECKSUM ERROR (%u)",csum);

	if(ip.offset != 0){
		trprintf(fp,"\n");
		return;
	}
	trprintf(fp," prot ");
	switch(uchar(ip.protocol)){
	case IP_PTCL:
		trprintf(fp,"IP\n");
		ip_dump(fp,bpp,check);
		break;
	case TCP_PTCL:
		trprintf(fp,"TCP\n");
		tcp_dump(fp,bpp,ip.source,ip.dest,check);
		break;
	case UDP_PTCL:
		trprintf(fp,"UDP\n");
		udp_dump(fp,bpp,ip.source,ip.dest,check);
		break;
	case ICMP_PTCL:
		trprintf(fp,"ICMP\n");
		icmp_dump(fp,bpp,ip.source,ip.dest,check);
		break;
	case AX25_PTCL:
		trprintf(fp,"AX25\n");
		ax25_dump(fp,bpp,check);
		break;
	default:
		trprintf(fp,"%u\n",uchar(ip.protocol));
		break;
	}
}
